@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION
SET /A "RTN_CODE=0"

SET "APP_BIN=%~1"
SET "SERVICE_UTIL=%~2"

REM Define the service
SET "SERVICE_EXEC=dokan1.sys"
SET "SERVICE_INF=dokan.inf"
SET "SERVICE_NAME=dokan1"
SET "SERVICE_INSTALL_PATH=%SYSTEMROOT%\system32\drivers\%SERVICE_EXEC%"
SET "SERVICE_INF_PATH=%CD%\%OS_ARCH%\%WIN_VER%\%SERVICE_INF%"
SET "LIBRARY_EXEC=dokan1.dll"
SET "LIBRARY_INSTALL_PATH=%SYSTEMROOT%\system32\%LIBRARY_EXEC%"

ECHO.
ECHO.NAME         : %SERVICE_NAME%
ECHO.INSTALL PATH : %SERVICE_INSTALL_PATH%
ECHO.LIB INSTALL PATH : %LIBRARY_INSTALL_PATH%
ECHO.INF PATH : %SERVICE_INF_PATH%
ECHO.

SET /A "STATE_INSTALL=0"
CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALL
IF NOT %STATE_INSTALL% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" not exist
    GOTO _exit
)

SET /A "STATE_RUNNING=0"
CALL :sub_check_running "%SERVICE_NAME%" STATE_RUNNING
IF %STATE_RUNNING% EQU 1 (
    ECHO.Stop service "%SERVICE_NAME%"...
    sc stop "%SERVICE_NAME%"
)

ECHO.Remove service "%SERVICE_NAME%"...
REM rundll32 setupapi.dll,InstallHinfSection DefaultUnInstall 132 %SERVICE_INF_PATH%
sc delete "%SERVICE_NAME%"
REM Check if service removed
SET /A WAIT_STATUS_UPDATED_COUNT=1
:_check_remove
SET /A "STATE_INSTALL=0"
CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALL
IF NOT %STATE_INSTALL% EQU 1 (
    ECHO.Service "%SERVICE_NAME%" removed
    GOTO _removed
)
IF %WAIT_STATUS_UPDATED_COUNT% GEQ 30 (
    ECHO.Service "%SERVICE_NAME%" is not yet removed
    REM try delete file
    GOTO _removed
)
CALL :sub_sleep1s
SET /A WAIT_STATUS_UPDATED_COUNT+=1
GOTO _check_remove
:_removed
IF EXIST "%SERVICE_INSTALL_PATH%" (
    DEL /F /Q "%SERVICE_INSTALL_PATH%"
)
IF EXIST "%LIBRARY_INSTALL_PATH%" (
    DEL /F /Q "%LIBRARY_INSTALL_PATH%"
)

:_exit
EXIT /B %RTN_CODE%

REM ----------------------------------------------------------
:sub_sleep1s
PING -n 2 127.0.0.1>nul 
EXIT /B

:sub_print_status
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qs %~1"') DO (
    SET /A "FOUND=1"
    ECHO.    ^> %%i
)
IF %FOUND% EQU 1 (
    FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qc %~1"') DO (
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "PATH_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DISPLAY_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DESCRIPTION"') DO (
            ECHO.    ^> %%i
        )
    )
)
EXIT /B

:sub_check_installed
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    REM all service states start with "SERVICE_"
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

:sub_check_running
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_RUNNING" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

ENDLOCAL
